# Deployment Guide

Step-by-step guide to deploy this app on DigitalOcean.

## 1. Create DigitalOcean Account

1. Sign up at [digitalocean.com](https://www.digitalocean.com)
2. Add a payment method
3. You'll get $200 free credit for 60 days (new accounts)

## 2. Create a Droplet

1. Click **"Create"** → **"Droplets"**
2. Choose these settings:
   - **Region:** Choose closest to your users
   - **Image:** Ubuntu 22.04 LTS
   - **Size:** Basic → Regular → $6/month (1GB RAM, 25GB SSD)
   - **Authentication:** SSH Key (Add your public key - see below if you need one)
3. **Hostname:** Give it a name like `notes-app`
4. Click **"Create Droplet"**
5. Wait ~1 minute for creation
6. Copy your droplet's IP address

### Need an SSH Key?
If you don't have one:
```bash
# Generate SSH key
ssh-keygen -t ed25519 -C "your.email@example.com"
# Press Enter for default location, optionally add passphrase

# View your public key
cat ~/.ssh/id_ed25519.pub
# Copy this entire output and paste it in DigitalOcean
```

## 3. Connect to Your Droplet

```bash
ssh root@YOUR_DROPLET_IP
```

### First-Time SSH Connection
You'll see a message about authenticity - type `yes` to continue:
```
The authenticity of host 'XX.XX.XX.XX' can't be established.
Are you sure you want to continue connecting (yes/no)? yes
```

## 4. Clone Your Repository

Once connected to your droplet:

```bash
# Install git
apt update && apt install -y git

# Clone your repo (replace with your GitHub URL)
git clone https://github.com/YOUR_USERNAME/minimal-app.git
cd minimal-app
```

## 5. Run the Deploy Script

```bash
bash deploy.sh
```

The script will:
1. Install Node.js and dependencies
2. Set up the app as a system service
3. Ask for your domain name (optional)
4. Configure nginx reverse proxy
5. Set up SSL certificate (if domain provided)

### During Deployment

You'll be prompted for:
- **Domain name** (optional): Enter like `example.com` or skip with Enter
  - If you provide a domain, SSL will be automatically configured

## 6. Access Your App

### With Domain
If you provided a domain, you need to configure DNS:

#### DNS Setup
Add these records in your domain's DNS settings:
- **A Record:** `@` → `YOUR_DROPLET_IP` (for example.com)
- **A Record:** `www` → `YOUR_DROPLET_IP` (for www.example.com)

Example for common DNS providers:
```
Type    Name    Value
A       @       165.227.123.45
A       www     165.227.123.45
```

Then access at:
- `https://yourdomain.com`
- `https://www.yourdomain.com`

### Without Domain
Access directly at: `http://YOUR_DROPLET_IP:3000`

## 7. Useful Commands

After deployment, SSH into your droplet and use:

```bash
# View app logs
journalctl -u minimal-notes -f

# Restart app
sudo systemctl restart minimal-notes

# Update app
cd /home/app/minimal-notes
git pull
npm install
sudo systemctl restart minimal-notes

# Check status
sudo systemctl status minimal-notes
```

## Troubleshooting

### Can't connect via SSH?
- Check firewall isn't blocking port 22
- Verify IP address is correct
- Ensure SSH key is added to DigitalOcean

### App not loading?
```bash
# Check if service is running
sudo systemctl status minimal-notes

# Check logs for errors
journalctl -u minimal-notes -n 50
```

### Domain not working?
- DNS changes can take 5-48 hours to propagate
- Verify both A records (@ and www) point to droplet IP
- Test DNS propagation: `nslookup yourdomain.com`
- Check nginx config: `sudo nginx -t`

## Costs

- **Droplet:** $6/month (1GB RAM)
- **Domain:** $10-15/year (if you buy one)
- **Total:** ~$7/month to run this app

## Destroy Droplet

To stop billing:
1. Go to DigitalOcean control panel
2. Click your droplet
3. "Destroy" → "Destroy Droplet"
4. Confirm destruction

## Deploying Multiple Apps

When you want to deploy a second app on the same droplet, here's what to change:

### Quick Checklist
1. **Different port** - Change `PORT=3001` in the second app
2. **Different service name** - Use `app2.service` instead of `minimal-notes.service`
3. **Different nginx config** - Create `/etc/nginx/sites-available/app2.com`
4. **Different domain/subdomain** - Use a subdomain like `app2.yourdomain.com`

### Example Changes for Second App

```bash
# In deploy.sh for app #2, modify these:
APP_NAME="app2"           # Different service name
PORT=3001                  # Different port
APP_DIR="/home/app/app2"  # Different directory

# Nginx will proxy to different port:
proxy_pass http://127.0.0.1:3001;  # Not 3000
```

### Subdomain Option
Instead of multiple domains, use subdomains:
- `notes.yourdomain.com` → Port 3000
- `todo.yourdomain.com` → Port 3001
- `blog.yourdomain.com` → Port 3002

Just add an A record for each subdomain pointing to the same droplet IP.

### Resource Limits
The $6/month droplet (1GB RAM) can handle:
- 3-4 small Node apps comfortably
- 2 apps if they use databases
- Monitor with `htop` to check memory usage

### Pro Tip
Copy your working `deploy.sh` and modify it for each new app. Keep the scripts in each app's repo so deployments stay simple.

---

That's it! Your app should be live. For issues, check the logs or restart the service.